function [mask] = edit_imgser(mode,offset)
%This function allows the editing of a series of images spread accross
%multiple directories.  This is specifically written to allow the removal
%of sections of images from a series for synapse classification, thus the
%expected directory structure is one after image alignment.
%Synatax:   [data] = edit_imgser();
%           mode = default = 0.  If it is 0, it takes the absolute position
%           of the start file + offset. Default offset is 0.  The offset is
%           the difference between the actual file position in the
%           directory and the number of that file.  So, if the filename is:
%           filename001.tif, but its position is actually 2, because the
%           sequence starts at 000, then the offset is +1.
%           If 1, we do a search for the number of the start file in other 
%           channels.  So, it will use the filenumber to find the proper
%           file.  This will depend on how files a specifically numbered of
%           course.  Currently only supports: filename000.tif for the edit
%           files.
%           If 2, we just edit all of the files in the current directory
%           exactly the same.
%Input:     you will be prompted to point to the image directory
%Output:    mask = the image mask.

if nargin<1
    mode = 0;   %default to zero
    offset = 0;
end

%Get the location of the image you want to edit
[img_name,channel_paths,filterindex] = uigetfile2({'*.tif','TIFF files (*.tif)';...
    '*.jpg','Jpeg files (*.jpg)';'*.gif','GIF files (*.gif)';...
    '*.bmp','Bitmap files (*.bmp)';'*.mat','Mat files (*.mat)';},'Open image','Multiselect','off');
%get the directory level above the image directory
sep_loc = strfind(channel_paths,filesep);
dir_up = channel_paths(1:sep_loc(end-1));
%now grab those directory names
dir_struct = dir(dir_up);  %grab the directory information
idx = [dir_struct.isdir];   %grab all of the isdir numbers
idx(1:2) = 0;               %remove the first two directories
dirnames = {dir_struct.name};   %grab the all of the names in the root
dirnames = dirnames(idx);  %don't want the first two

%now open the image and create a mask
curr_img = imread([channel_paths,img_name]);  %grab the image
b = size(curr_img);
%select ROI and create mask
%Display the reference image
figure('units','pixels','position',[20 35 b(1,2) b(1,1)],'name','Please Select Your ROIs Here','menubar','none','toolbar','none');
%Note: For future reference, You can get the actual screen size by the
%command: get(0,'screensize')
figure1 = gcf;      %Get figure1's handle
curr_img = imadjust(curr_img);
imshow(curr_img);
i = 1;              %initiate indexes
j = 1;
while i==1              %the ROI selector
    figure(figure1);
    [roi_mask(:,:,j),poly_loc(j).x,poly_loc(j).y] = roipoly;
    %Draw the mask on the selection image so we can keep track of the cells
    %we have selected.
    curr_img(roi_mask(:,:,j)) = intmax(class(curr_img));        %Use logical selection to imprint the mask on the image
    imshow(curr_img);                        %Display the Image
    axis off;
    set(gca,'position',[0 0 1 1]);
    %Prompt the user for more ROI selection
    choice = menu('Do you want to select another ROI?','Yes - more please','No - no more','position','center');
    if choice==1
        j = j+1;        %step up the image storage index.
    else
        i = 0;          %end the ROI selection process.
    end
end
delete(figure1);        %close figure1
%if there are more than 1 ROIs merge the masks
if size(roi_mask,3)>1
    mask = roi_mask(:,:,1);
    for k = 2:size(roi_mask,3)
        mask = mask|roi_mask(:,:,k);    %join logical arrays
    end
else    %one ROI
    mask = roi_mask;
end

if mode==2  %mode 2 works in its own directory
    %grab the filenames in the current directory
    dir_struct = dir(channel_paths);  %grab the directory information
    idx = [dir_struct.isdir];   %grab all of the isdir numbers
    filenames = {dir_struct.name};   %grab the all of the names in the root
    filenames = filenames(~idx);  %don't want the first two
    %now go through each file and edit
    for l = 1:size(filenames,2)
        curr_img = imread([channel_paths,filenames{l}]);  %grab the image
        curr_img(mask) = 0;  %select the desired image pixels
        savtif(curr_img,filenames{l},channel_paths);  %save the image
    end
else    %work through the directory list
    %Now go into every directory, find the correct image and delete the region
    %parse the original find to find the correct image number
    num_str = img_name(end-6:end-4);  %this is obviously the dumb way, and only works with the file the program expects (DAPI+SYN)
    %we'll get smart if we need to
    for l = 1:size(dirnames,2)
        %get the files
        dir_struct = dir([dir_up,dirnames{l}]);  %grab the directory information
        idx = [dir_struct.isdir];   %grab all of the isdir numbers
        dir_tmp = {dir_struct.name};   %grab the all of the names in the root
        filenames = dir_tmp(~idx);  %files
        switch mode
            case 1  %relative mode
                img_loc = strfind(filenames,num_str);   %where does this number reside in the files
                for m = 1:size(filenames,2);
                    if ~isempty(img_loc{m})     %here is the file
                        curr_img = imread([dir_up,dirnames{l},filesep,filenames{m}]);  %grab the image
                        curr_img(mask) = 0;  %select the desired image pixels
                        savtif(curr_img,filenames{m},[dir_up,dirnames{l},filesep]);  %save the image
                    end
                end
            otherwise  %absolute mode
                m = str2num(num_str)+offset;     %position + 1, assuming starting at 000
                curr_img = imread([dir_up,dirnames{l},filesep,filenames{m}]);  %grab the image
                curr_img(mask) = 0;  %select the desired image pixels
                savtif(curr_img,filenames{m},[dir_up,dirnames{l},filesep]);  %save the image
        end
    end
end

%--------------------------------------------------------------------------
function [] = savtif(img,filename,pathname)
%A function to save a tiff
%remove the file type if needed
if strcmp('.',filename(1,end-3)) || strcmp('.',filename(1,end-4))  %note this recognizes '.tiff', but leaves the '.'
    filename = filename(1:end-4);   %remove the file type first
end
%prepare to output other classes of images
imgclass = class(img);      %get image type

%get the size of the image
[y,x] = size(img);

%create the tag structure for the tiff image
tagstruct.ImageLength = y;
tagstruct.ImageWidth = x;
tagstruct.Photometric = 1;      %min is black
switch imgclass     %for now we only traffic in 16bit and 32bit tiffs
    case 'uint32'
        tagstruct.BitsPerSample = 32;   %32bit
    case 'uint8'
        tagstruct.BitsPerSample = 8;    %alright we'll allow 8bit output
        img = im2uint8(img);
    otherwise
        tagstruct.BitsPerSample = 16;   %16bit
        img = im2uint16(img);
end
tagstruct.SamplesPerPixel = 1;
tagstruct.RowsPerStrip = 2;
tagstruct.PlanarConfiguration = Tiff.PlanarConfiguration.Chunky;
tagstruct.Software = 'MATLAB';
tagstruct.ImageDescription = 'Matlab, Gordon';

%now save the image
warning('OFF')
h = Tiff([pathname,filename,'.tif'],'w');    %open tiff object
h.setTag(tagstruct);            %set the tag structure
h.write(img); %write the image & rotate it to video coordinates
close(h);                       %close the file
warning('ON')